<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
//include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
//$usuarioId = TokenValidator::validar($conn);

try {
    $body = file_get_contents("php://input");
    $data = json_decode($body, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("JSON inválido: " . json_last_error_msg());
    }

    if (!isset($data['Nombre'], $data['Psw'], $data['Perfil'], $data['Principal'], $data['Nombre_Completo'], 
        $data['VisualizaCosto'], $data['VisualizaUtilidad'], $data['CanjeaDocumento'],
        $data['EditarFecha'], $data['EditarComboVendedor'], $data['EditarComboCaja'],
        $data['EditarTipoSerieDoc'], $data['EstadoCheckCajaKardex'],
        $data['IdEmpresa'], $data['IdUsuario'], $data['Estado'], $data['sedes'], $data['cajas'])) {
        throw new Exception("Faltan campos requeridos en el JSON.");
    }

    $conn->beginTransaction();

    $sql = "SELECT * FROM im_usuario(
        :nombre, :psw, :perfil, :principal, :nombre_completo, 
        :visualiza_costo, :visualiza_utilidad, :canjea_documento,
        :editar_fecha, :editar_combo_vendedor, :editar_combo_caja,
        :editar_tipo_serie_doc, :estado_check_kardex,
        :idempresa, :idusuario, :estado, 
        :sedes_json, :cajas_json
    ) AS idusuario";

    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':nombre', $data['Nombre'], PDO::PARAM_STR);
    $stmt->bindValue(':psw', $data['Psw'], PDO::PARAM_STR);
    $stmt->bindValue(':perfil', $data['Perfil'], PDO::PARAM_STR);
    $stmt->bindValue(':principal', filter_var($data['Principal'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':nombre_completo', $data['Nombre_Completo'], PDO::PARAM_STR);
    $stmt->bindValue(':visualiza_costo', filter_var($data['VisualizaCosto'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':visualiza_utilidad', filter_var($data['VisualizaUtilidad'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':canjea_documento', filter_var($data['CanjeaDocumento'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':editar_fecha', filter_var($data['EditarFecha'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':editar_combo_vendedor', filter_var($data['EditarComboVendedor'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':editar_combo_caja', filter_var($data['EditarComboCaja'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':editar_tipo_serie_doc', filter_var($data['EditarTipoSerieDoc'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':estado_check_kardex', filter_var($data['EstadoCheckCajaKardex'], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':idempresa', (int)$data['IdEmpresa'], PDO::PARAM_INT);
    $stmt->bindValue(':idusuario', (int)$data['IdUsuario'], PDO::PARAM_INT);
    $stmt->bindValue(':estado', $data['Estado'], PDO::PARAM_STR);
    $stmt->bindValue(':sedes_json', json_encode($data['sedes'], JSON_UNESCAPED_UNICODE), PDO::PARAM_STR);
    $stmt->bindValue(':cajas_json', json_encode($data['cajas'], JSON_UNESCAPED_UNICODE), PDO::PARAM_STR);

    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result && $result['idusuario'] > 0) {
        $conn->commit();
        echo json_encode([
            "ESTADO" => "1",
            "ID" => $result['idusuario'],
            "MENSAJE" => "LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE"
        ], JSON_UNESCAPED_UNICODE);
    } else {
        $conn->rollBack();
        echo json_encode([
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => $result['mensaje'] ?? "No se pudo registrar el usuario"
        ], JSON_UNESCAPED_UNICODE);
    }

} catch (PDOException $e) {
    $conn->rollBack();
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
