<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar parámetros
if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
    error_response("Parámetros insuficientes.");
}

$empresaId    = $datos[0]; // ID Empresa
$sucursalId   = $datos[1]; // ID Sucursal
$ingrediente  = $datos[2]; // Ingrediente activo (texto libre)
$almacenId    = $datos[3]; // ID Almacén (0 para todos)

try {
    $sql = "SELECT * FROM buscar_compatibles_por_ingrediente(:empresaId, :sucursalId, :ingrediente, :almacenId)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(":empresaId", $empresaId, PDO::PARAM_INT);
    $stmt->bindParam(":sucursalId", $sucursalId, PDO::PARAM_INT);
    $stmt->bindParam(":ingrediente", $ingrediente, PDO::PARAM_STR);
    $stmt->bindParam(":almacenId", $almacenId, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        success_response("No se encontraron productos compatibles.", []);
    } else {
        success_response("Productos compatibles encontrados.", $rows);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "mensaje" => "Error DB: " . $e->getMessage(),
        "data" => []
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}

// ✅ Enviar respuesta exitosa
function success_response($mensaje, $data = []) {
    echo json_encode([
        "estado" => "00",
        "mensaje" => $mensaje,
        "data" => $data
    ], JSON_UNESCAPED_UNICODE);
    exit();
}

// ❌ Enviar error con formato uniforme
function error_response($mensaje) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "mensaje" => $mensaje,
        "data" => []
    ], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
