<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo que contiene la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

// Validar que el cuerpo de la solicitud no esté vacío y que $datos[0] no sea NULL
if (!isset($datos[0])) {
    error_response("El cuerpo de la solicitud no es válido o está vacío.");
}

$rows = array();
$sql = "SELECT * FROM provincias WHERE departamento_id = :departamento_id ORDER BY provincia";

try {
    // Preparar la consulta
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':departamento_id', $datos[0], PDO::PARAM_INT);
    $stmt->execute();

    // Obtener los resultados
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($rows)) {
        // No se encontraron registros
        print_json([]);
    } else {
        // Imprimir la respuesta en formato JSON
        print_json($rows);
    }
} catch (PDOException $e) {
    error_response("ERROR: Could not execute the query. " . $e->getMessage());
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>